clc, clear, close all
Zero = [2.872748438 -0.088105225];
LibI = myInterfacciaDAQ;
LibO = myOutputFile;
LibS = mySignalMaker;
LibT = myTdmsReader;

%
fileRef = 'myTdmsReader.m';
mainDir = replace(which(fileRef),fileRef,'');
cd(mainDir)

parent = "results NewtonForce";

ss = ["(Apr 07 10_50_37)",... %top
     "(Apr 07 10_47_42)",... %bot]
     "(Apr 07 10_45_33)", ... %side
     "(Apr 07 10_52_31)", ...% sync step
     "(Apr 07 10_58_15)"]; % sync lin

lege = ["top. (stair sig.)", "bot. (stair sig.)" "side. (stai sig.)" "all. (stair sig.)" "all. (ramp sig.)"];
props = ["top", "bot" "side" "sync_step" "sync_lin"];
data = struct;
for i = 1:4 %length(ss)
s = LibO.txt2struct(mainDir+parent+filesep+"Loa"+filesep+ss(i));
% LibO.plotMySym(s)
[ d, data.t ] = LibO.extractFromFile( s.loa );
data.(props(i)) = d(:,1);

for j=0:7
    data.sig(j+1, i) = mean( d(data.t>=j*10+0.5 & data.t<=j*10+9.5));
end
out=LibT.computeCd( [data.sig(:,i) zeros(8,1)],[], Zero);
data.drag(:,i) = out.Drag;
end
data.drag = -(data.drag-data.drag(1,:));


koef = -1;
data.sig(:,1) = data.sig(1)-2*(data.sig(:,1)-data.sig(1));
data.drag(:,1) = data.drag(:,1)*koef;


x = linspace(5.5,9.5,8);
subplot(2,1,1)
plot(x,data.sig,'-o'), ylabel({'ELECTRIC MEASURED'; 'SIGNAL [V]'}), hold on

subplot(2,1,2)
plot(x,data.drag,'-o'), ylabel('AIR THRUST [N]'), hold on
plot(x,sum(data.drag(:,1:3).*[-1*koef 1 1],2),'-.')
xlabel('Voltage Control Value [V]')
f = gcf; f.Color = 'w'; 

% Errore relativo del segnale sync vs somma dei singoli segnali
error = (data.drag(:,4)-sum(data.drag(:,1:3).*[-1 1 1],2))./data.drag(:,4);
disp('Voltage | Errore relativo')
disp([x', error])

disp('Voltage | Drags')
disp([x' data.drag])

%
i = 5;
s = LibO.txt2struct(mainDir+parent+filesep+"Loa"+filesep+ss(i));
% LibO.plotMySym(s)
[ d, t ] = LibO.extractFromFile( s.loa );
data.(props(i)) = d(:,1);
L = length(t);
out=LibT.computeCd( [data.sync_lin zeros(L,1)],[], Zero);

subplot(2,1,1)
sLin = movmean(data.sync_lin, [1 1]*3000);
plot(linspace(5.5, 9.5, L), sLin,':k')
lll=legend(lege); lll.Title.String='Jet singals';

subplot(2,1,2)
lin = -(out.Drag-out.Drag(1));
lin = movmean(lin,[1 1]*3000);
plot(linspace(5.5, 9.5, L), lin,':k')


